// SPDX-License-Identifier: GPL-2.0-only
/*
 * UHR handling
 *
 * Copyright(c) 2025 Intel Corporation
 */

#include "ieee80211_i.h"

void
ieee80211_uhr_cap_ie_to_sta_uhr_cap(struct ieee80211_sub_if_data *sdata,
				    struct ieee80211_supported_band *sband,
				    const struct ieee80211_uhr_capa *uhr_capa,
				    u8 uhr_capa_len,
				    struct link_sta_info *link_sta)
{
	struct ieee80211_sta_uhr_cap *uhr_cap = &link_sta->pub->uhr_cap;

	memset(uhr_cap, 0, sizeof(*uhr_cap));

	if (!uhr_capa ||
	    !ieee80211_get_uhr_iftype_cap_vif(sband, &sdata->vif))
		return;

	uhr_cap->has_uhr = true;

	uhr_cap->mac = uhr_capa->mac;
	uhr_cap->phy = *ieee80211_uhr_phy_cap(uhr_capa);
}
