% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fastq.R
\name{maskPositionsByQuality}
\alias{maskPositionsByQuality}
\title{Mask sequence positions with low quality}
\usage{
maskPositionsByQuality(
  data,
  min_quality = 70,
  sequence = "sequence_alignment",
  quality_num = "quality_alignment_num"
)
}
\arguments{
\item{data}{\code{data.frame} containing sequence data.}

\item{min_quality}{minimum quality score. Positions with sequencing quality 
less than \code{min_qual} will be masked.}

\item{sequence}{column in \code{data} with sequence data to be masked.}

\item{quality_num}{column in \code{data} with quality scores (a
string of numeric values, comma separated) that can
be used to mask \code{sequence}.}
}
\value{
Modified \code{data} data.frame with an additional field containing 
          quality masked sequences. The  name of this field is created 
          concatenating the \code{sequence} name and \code{"_masked"}.
}
\description{
\code{maskPositionsByQuality} will replace positions that 
have a sequencing quality score lower that \code{min_quality} with an
\code{"N"} character.
}
\examples{
db <- airr::read_rearrangement(system.file("extdata", "example_quality.tsv", package="alakazam"))
fastq_file <- system.file("extdata", "example_quality.fastq", package="alakazam")
db <- readFastqDb(db, fastq_file, quality_offset=-33)
maskPositionsByQuality(db, min_quality=90, quality_num="quality_alignment_num")

}
\seealso{
\link{readFastqDb} and \link{getPositionQuality}
}
