from collections.abc import Generator, Iterable, Iterator, Mapping
from typing import Generic, TypeVar

_T = TypeVar("_T")

class UnionFind(Generic[_T]):
    parents: Mapping[_T, _T]
    weights: Mapping[_T, int]
    def __init__(self, elements: Iterable[_T] | None = None) -> None: ...
    def __getitem__(self, object: _T) -> _T: ...
    def __iter__(self) -> Iterator[_T]: ...
    def to_sets(self) -> Generator[set[_T]]: ...
    def union(self, *objects: _T) -> None: ...
