/**
 * @file  xPrfMem.h
 * @brief Platform Reference Firmware - exposes Platform specific features for
 *        Mem
 */
/* Copyright 2022-2023 Advanced Micro Devices, Inc. All rights reserved.    */
// SPDX-License-Identifier: MIT

#pragma once

// 1 Gigabyte
#define GIGB (1 << 30)

#define SPD_BUFFER_SIZE        1024

/**
 * @brief Host to APCB Channel Translation structure
 */
typedef struct _HOST_TO_APCB_CHANNEL_XLAT {
  uint8_t   RequestedChannelId;   ///< Requested Channel ID
  uint8_t   TranslatedChannelId;  ///< Translated Channel ID
} HOST_TO_APCB_CHANNEL_XLAT;

/**
 * @brief Structure defining Memory ticks
 * @details This provides the memory clock to tick ps value relationship, to be tabulated for reference
 */
typedef struct _MEM_TCK_ENTRY {
  uint16_t  Memclk; ///< Memory clock
  uint16_t  TckPs;  ///< Ticks ps
} MEM_TCK_ENTRY;

const MEM_TCK_ENTRY MemFreqToTckTable[] = {
  {1000,1000},
  {1050, 952},
  {1067, 938},
  {1200, 833},
  {1333, 750},
  {1367, 732},
  {1400, 714},
  {1433, 698},
  {1467, 682},
  {1500, 667},
  {1533, 652},
  {1567, 638},
  {1600, 625},
  {1633, 612},
  {1667, 599},
  {1700, 588},
  {1733, 577},
  {1767, 565},
  {1800, 555},
  {1833, 545},
  {1867, 535},
  {1900, 526},
  {1933, 517},
  {1967, 508},
  {2000, 500},
  {2033, 491},
  {2067, 483},
  {2100, 476},
  {2133, 468},
  {2167, 461},
  {2200, 454},
  {2233, 447},
  {2267, 441},
  {2300, 434},
  {2333, 428},
  {2367, 422},
  {2400, 416},
  {2433, 411},
  {2467, 405},
  {2500, 400},
  {2550, 392},
  {2600, 384},
  {2650, 377},
  {2700, 370},
  {2750, 363},
  {2800, 357},
  {2850, 350},
  {2900, 344},
  {2950, 338},
  {3000, 333},
  {3050, 327},
  {3100, 322},
  {3150, 317},
  {3200, 312},
  {3250, 307},
  {3300, 303},
  {3350, 298},
  {3400, 294},
  {3450, 289},
  {3500, 285},
  {3550, 281},
  {3600, 277},
  {3650, 273},
  {3700, 270},
  {3750, 266},
  {3800, 263},
  {3850, 259},
  {3900, 256},
  {3950, 253},
  {4000, 250},
  {4050, 246},
  {4100, 243},
  {4150, 240},
  {4200, 238},
  {4250, 235},
  {4300, 232},
  {4350, 229},
  {4400, 227}
};

uint8_t MemSpdDdr4[] = {
  0x23, 0x06, 0x0c, 0x02, 0x84, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x09, 0x03, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x0c, 0xf4, 0x1b, 0x00, 0x00, 0x6c, 0x6c, 0x6c, 0x11, 0x08, 0x74, 0x20, 0x08,
  0x00, 0x05, 0x70, 0x03, 0x00, 0xa8, 0x1e, 0x2b, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x36, 0x16, 0x36,
  0x16, 0x36, 0x16, 0x36, 0x00, 0x20, 0x2b, 0x0c, 0x2b, 0x0c, 0x2b, 0x0c, 0x2b, 0x0c, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0xb5, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x9e, 0x65,
  0x11, 0x11, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xde, 0x27,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x2c, 0x01, 0x13, 0x24, 0xb1, 0xff, 0x42, 0xc5, 0x31, 0x36, 0x41, 0x54, 0x46, 0x31, 0x47,
  0x36, 0x34, 0x41, 0x5a, 0x2d, 0x32, 0x47, 0x31, 0x41, 0x59, 0x20, 0x20, 0x20, 0x59, 0x80, 0x2c,
  0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x69,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

HOST_TO_APCB_CHANNEL_XLAT Sp5ChannelXlatTable[] = {
  // Requested   Translated
  { 0,          2 },
  { 1,          4 },
  { 2,          5 },
  { 3,          0 },
  { 4,          1 },
  { 5,          3 },
  { 6,          8 },
  { 7,          10},
  { 8,          11},
  { 9,          6 },
  { 10,         7 },
  { 11,         9 },
  { 0xFF,       0xFF},
};
